unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  Buttons, ComCtrls, MaskEdit, StdCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    LabeledEdit3: TLabeledEdit;
    MaskEdit1: TMaskEdit;
    MaskEdit2: TMaskEdit;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    StatusBar1: TStatusBar;
    procedure FormShow(Sender: TObject);
    procedure MaskEdit1KeyPress(Sender: TObject; var Key: char);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }

procedure TForm1.FormShow(Sender: TObject);
begin
  MaskEdit1.SetFocus;
end;

procedure TForm1.MaskEdit1KeyPress(Sender: TObject; var Key: char);
begin
  if Key = #13 then
  begin
    MaskEdit2.SetFocus;
    SpeedButton1.Down:= false;
    SpeedButton2.Down:= false;
    SpeedButton3.Down:= false;
    SpeedButton4.Down:= false;
    exit;
  end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  LabeledEdit3.Text:= IntToStr(StrToInt(MaskEdit1.Text)
                    + StrToInt(MaskEdit2.Text));
  StatusBar1.SimpleText:= 'Сложение';
  MaskEdit1.SetFocus;
  MaskEdit1.SelectAll;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  LabeledEdit3.Text:= IntToStr(StrToInt(MaskEdit1.Text)
                    - StrToInt(MaskEdit2.Text));
  StatusBar1.SimpleText:= 'Вычитание';
  MaskEdit1.SetFocus;
  MaskEdit1.SelectAll;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  LabeledEdit3.Text:= IntToStr(StrToInt(MaskEdit1.Text)
                    * StrToInt(MaskEdit2.Text));
  StatusBar1.SimpleText:= 'Умножение';
  MaskEdit1.SetFocus;
  MaskEdit1.SelectAll;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  try
    LabeledEdit3.Text:= IntToStr(StrToInt(MaskEdit1.Text) div
                        StrToInt(MaskEdit2.Text));
  except
    on EDivByZero do
    begin
      ShowMessage('Ошибка! Произошло деление на ноль. ' +
                  'Вероятно Вы ошиблись при вводе второго числа');
      exit;
    end;
  end;
  StatusBar1.SimpleText:= 'Деление нацело';
  MaskEdit1.SetFocus;
  MaskEdit1.SelectAll;
end;

initialization
  {$I unit1.lrs}

end.

